//
// usage: i18n.load("ja")
//        var text = i18n.msg.KEY_TEXT
var i18n = (function() {
    var msg = {};

    var ja = {
        SERVICE_MANUAL: "SERVICE MANUAL",
        MAIN_TARGETREQUIRED: "印刷対象を選択して下さい。",
        // index.html
        INDEX_MODEL: "車名表示",
        INDEX_TOP: "TOP",
        INDEX_DTC: "DTC検索",
        INDEX_LOOKUP: "索引",
        INDEX_SEARCH: "検索",
        INDEX_WIRING: "配線図",
        INDEX_PRINT: "印刷",
        INDEX_PRINTSSI: "タイプ",
        INDEX_PRINTSI: "項",
        INDEX_PRINTSECTION: "章",
        INDEX_HELP: "ヘルプ",
        INDEX_REPAIR_HARNESS: "R/H",
        INDEX_KUBUN: "区分：",
        INDEX_BROWSERNOTRECOMMENDED: "推奨されていないブラウザです。\r\n推奨ブラウザは Internet Explorer バージョン9,10,11 または Google Chrome です。",
		INDEX_SHINKAI:"New carinfo",
        INDEX_SST: "SST",
        // dtc.html
        DTC_PAGETITLE: "DTC検索",
        DTC_MESSAGE1: "英数字ボタンをクリックして、DTCを入力してください。",
        DTC_MESSAGE2: "OKボタンで検索結果を表示します。",
        DTC_MESSAGE3: "すべてのDTCを表示します。",
        DTC_SHOWALL: "一覧表示",
        DTC_SEARCH_RESULT: "DTC検索結果",
        DTC_HEADING_CODE: "故障コードNo.",
        DTC_HEADING_ITEM: "項目",
        DTC_HEADING_LINK: "参照先",
        DTC_BACKTO_SEARCH: "検索画面に戻る",
        DTC_NO_ITEM: "DTCコードが見つかりません。",
        DTC_CLEAR: "Clear",
        DTC_BACK_SPACE: "Back Space",
        DTC_OK: "OK",
        // wiring.html
        WIRING_TITLE: "配線図索引",
        WIRING_DESCRIPTION: "検索したい言葉の頭文字をクリックしてください。",
        WIRING_SHOWALL: "一覧表示",
        WIRING_BASICDIAG: "基本診断手順",
        WIRING_NOTE: "作業上の注意",
        WIRING_CAUTION: "※背景色がグレーのものは選択できません。",
        WIRING_SEARCH_RESULT: "配線図検索結果",
        // lookup.html
        LOOKUP_TITLE: "索引",
        LOOKUP_DESCRIPTION: "検索したい言葉の頭文字をクリックしてください。",
        LOOKUP_SEARCH_RESULT: "検索結果",
        LOOKUP_CAUTION: "※背景色がグレーのものは選択できません。",
        CLICK_IMAGE: "画像をクリックすると拡大します。",
        // search.html
        SEARCH_BOX: "検索",
        SEARCH_BTN: "検索",
        SEARCH_OPTION_TITLE: "検索範囲",
        SEARCH_RESULT_TITLE: "検索結果",
    };
    var en = {
        SERVICE_MANUAL: "SERVICE MANUAL",
        MAIN_TARGETREQUIRED: "Please select an item to print.",
        INDEX_MODEL: "Model Selection Menu",
        INDEX_TOP: "TOP",
        INDEX_DTC: "DTC Search",
        INDEX_LOOKUP: "Index",
        INDEX_SEARCH: "Search",
        INDEX_WIRING: "Wiring Diagram",
        INDEX_PRINT: "Print",
        INDEX_PRINTSSI: "Type",
        INDEX_PRINTSI: "Subsection",
        INDEX_PRINTSECTION: "Chapter",
        INDEX_HELP: "HELP",
        INDEX_REPAIR_HARNESS: "R/H",
        INDEX_KUBUN: "INDEX_KUBUN_EN",
        INDEX_BROWSERNOTRECOMMENDED: "This browser is not recommended.\r\nInternet Explorer ver.9, 10, 11 or Google Chrome are recommended.",
		INDEX_SHINKAI:"New carinfo",
        INDEX_SST: "SST",
        DTC_PAGETITLE: "DTC Search",
        DTC_MESSAGE1: "Click ALPHANUMERIC and enter the DTC.",
        DTC_MESSAGE2: "Click OK to display the search results.",
        DTC_MESSAGE3: "Display all the DTCs.",
        DTC_SHOWALL: "List",
        DTC_SEARCH_RESULT: "DTC search results",
        DTC_HEADING_CODE: "DTC",
        DTC_HEADING_ITEM: "Item",
        DTC_HEADING_LINK: "Reference",
        DTC_BACKTO_SEARCH: "Back to the search page",
        DTC_NO_ITEM: "The entered DTC cannot be found.",
        DTC_CLEAR: "Clear",
        DTC_BACK_SPACE: "Back Space",
        DTC_OK: "OK",
        WIRING_TITLE: "Wiring Diagram Index",
        WIRING_DESCRIPTION: "Click the initial letter of the word or phrase to be searched.",
        WIRING_SHOWALL: "List",
        WIRING_BASICDIAG: "Basic diagnostic procedure",
        WIRING_NOTE: "Working precautions",
        WIRING_CAUTION: "Characters displayed with a gray background are not available.",
        WIRING_SEARCH_RESULT: "Wiring diagram search results",
        LOOKUP_TITLE: "Index",
        LOOKUP_DESCRIPTION: "Click the initial letter of the word or phrase to be searched.",
        LOOKUP_SEARCH_RESULT: "Search results",
        LOOKUP_CAUTION: "Characters displayed with a gray background are not available.",
        CLICK_IMAGE: "Click the image to see the enlarged image.",
        SEARCH_BOX: "Search",
        SEARCH_BTN: "Search",
        SEARCH_OPTION_TITLE: "Search range",
        SEARCH_RESULT_TITLE: "Search results",
    };
    var es = {
        SERVICE_MANUAL: "MANUAL DE SERVICIO",
        MAIN_TARGETREQUIRED: "Seleccione un elemento para imprimir",
        INDEX_MODEL: "Menú de selección de modelo",
        INDEX_TOP: "SUPERIOR",
        INDEX_DTC: "Búsqueda en DTC",
        INDEX_LOOKUP: "Índice",
        INDEX_SEARCH: "Búsqueda",
        INDEX_WIRING: "Diagrama de cableado",
        INDEX_PRINT: "Imprimir",
        INDEX_PRINTSSI: "Tipo",
        INDEX_PRINTSI: "Subsección",
        INDEX_PRINTSECTION: "Capítulo",
        INDEX_HELP: "Ayuda",
        INDEX_REPAIR_HARNESS: "R/H",
        INDEX_KUBUN: "INDEX_KUBUN_ES",
        INDEX_BROWSERNOTRECOMMENDED: "Este navegador no es el recomendado.\r\nSe recomienda usar Internet Explorer Ver. 9, 10, 11 o Google Chrome.",
		INDEX_SHINKAI:"New carinfo",
        INDEX_SST: "SST",
        DTC_PAGETITLE: "Búsqueda en DTC",
        DTC_MESSAGE1: "Haga clic en Alfanumérico y luego introduzca el DTC.",
        DTC_MESSAGE2: "Haga clic en Aceptar para ver los resultados de la búsqueda.",
        DTC_MESSAGE3: "Mostrar todos los DTC.",
        DTC_SHOWALL: "LISTA",
        DTC_SEARCH_RESULT: "Resultados de la b&uacute;squeda de DTC",
        DTC_HEADING_CODE: "DTC",
        DTC_HEADING_ITEM: "Ref.",
        DTC_HEADING_LINK: "Referencia",
        DTC_BACKTO_SEARCH: "Regresar a la p&aacute;gina de b&uacute;squeda",
        DTC_NO_ITEM: "No se puede encontrar el DTC introducido.",
        DTC_CLEAR: "Borrar",
        DTC_BACK_SPACE: "Retroceso",
        DTC_OK: "OK",
        WIRING_TITLE: "Índice de diagramas de cableado",
        WIRING_DESCRIPTION: "Haga clic en la letra inicial de la palabra o la frase que va a buscar.",
        WIRING_SHOWALL: "Lista",
        WIRING_BASICDIAG: "Procedimiento b&aacute;sico de diagn&oacute;stico",
        WIRING_NOTE: "Precauciones al trabajar",
        WIRING_CAUTION: "Los caracteres que aparecen con fondo gris no están disponibles.",
        WIRING_SEARCH_RESULT: "Resultados de la b&uacute;squeda de diagramas de cableado",
        LOOKUP_TITLE: "Índice",
        LOOKUP_DESCRIPTION: "Haga clic en la letra inicial de la palabra o la frase que va a buscar.",
        LOOKUP_SEARCH_RESULT: "Resultados de la b&uacute;squeda",
        LOOKUP_CAUTION: "Los caracteres que aparecen con fondo gris no están disponibles.",
        CLICK_IMAGE: "Haga clic en la imagen para verla ampliada.",
        SEARCH_BOX: "Búsqueda",
        SEARCH_BTN: "Búsqueda",
        SEARCH_OPTION_TITLE: "Margen de búsqueda",
        SEARCH_RESULT_TITLE: "Resultados de la búsqueda",
    };
    var de = {
        SERVICE_MANUAL: "WERKSTATTHANDBUCH",
        MAIN_TARGETREQUIRED: "Bitte einen Punkt zum Drucken auswählen",
        INDEX_MODEL: "Modellauswahl-Menü",
        INDEX_TOP: "TOP",
        INDEX_DTC: "DTC-Suche",
        INDEX_LOOKUP: "Index",
        INDEX_SEARCH: "Suche",
        INDEX_WIRING: "Schaltpläne",
        INDEX_PRINT: "Drucken",
        INDEX_PRINTSSI: "Typ",
        INDEX_PRINTSI: "Unterabschnitt",
        INDEX_PRINTSECTION: "Kapitel",
        INDEX_HELP: "Hilfe",
        INDEX_REPAIR_HARNESS: "R/H",
        INDEX_KUBUN: "INDEX_KUBUN_DE",
        INDEX_BROWSERNOTRECOMMENDED: "Dieser Browser wird nicht empfohlen.\r\nEs wird Internet Explorer Ver. 9, 10, 11 oder Google Chrome empfohlen.",
		INDEX_SHINKAI:"New carinfo",
        INDEX_SST: "SST",
        DTC_PAGETITLE: "DTC-Suche",
        DTC_MESSAGE1: "Klicken Sie zur Eingabe des DTC auf die alphanumerischen Schaltflächen.",
        DTC_MESSAGE2: "Klicken Sie auf OK, um die Suchergebnisse anzuzeigen.",
        DTC_MESSAGE3: "Alle DTCs anzeigen.",
        DTC_SHOWALL: "LISTE",
        DTC_SEARCH_RESULT: "DTC&hyphen;Suchergebnisse",
        DTC_HEADING_CODE: "DTC",
        DTC_HEADING_ITEM: "Bauteil",
        DTC_HEADING_LINK: "Referenz",
        DTC_BACKTO_SEARCH: "Zur&uuml;ck zur Suchseite",
        DTC_NO_ITEM: "Der eingegebene DTC kann nicht gefunden werden.",
        DTC_CLEAR: "Löschen",
        DTC_BACK_SPACE: "Rücktaste",
        DTC_OK: "OK",
        WIRING_TITLE: "Schaltplan&hyphen;Index",
        WIRING_DESCRIPTION: "Klicken Sie auf den Anfangsbuchstaben des zu suchenden Wortes oder der zu suchenden Wortgruppe.",
        WIRING_SHOWALL: "Liste",
        WIRING_BASICDIAG: "Grundlegendes Diagnoseverfahren",
        WIRING_NOTE: "Sicherheitsvorkehrungen",
        WIRING_CAUTION: "Dunkel hinterlegte Zeichen sind nicht verfügbar.",
        WIRING_SEARCH_RESULT: "Verdrahtungsdiagramm&hyphen;Suchergebnisse",
        LOOKUP_TITLE: "Index",
        LOOKUP_DESCRIPTION: "Klicken Sie auf den Anfangsbuchstaben des zu suchenden Wortes oder der zu suchenden Wortgruppe.",
        LOOKUP_SEARCH_RESULT: "Suchergebnisse",
        LOOKUP_CAUTION: "Dunkel hinterlegte Zeichen sind nicht verfügbar.",
        CLICK_IMAGE: "Auf das Bild klicken, um es zu vergrößern.",
        SEARCH_BOX: "Suche",
        SEARCH_BTN: "Suche",
        SEARCH_OPTION_TITLE: "Suchbereich",
        SEARCH_RESULT_TITLE: "Suchergebnisse",
    };
    var fr = {
        SERVICE_MANUAL: "MANUEL D&rsquo;ATELIER",
        MAIN_TARGETREQUIRED: "Veuillez sélectionner un élément à imprimer",
        INDEX_MODEL: "Menu de s&eacute;lection des mod&egrave;les",
        INDEX_TOP: "HAUT",
        INDEX_DTC: "Recherche de DTC",
        INDEX_LOOKUP: "Index",
        INDEX_SEARCH: "Recherche",
        INDEX_WIRING: "Schéma de câblage",
        INDEX_PRINT: "Impression",
        INDEX_PRINTSSI: "Type",
        INDEX_PRINTSI: "Sous-section",
        INDEX_PRINTSECTION: "Chapitre",
        INDEX_HELP: "Aide",
        INDEX_REPAIR_HARNESS: "R/H",
        INDEX_KUBUN: "INDEX_KUBUN_FR",
        INDEX_BROWSERNOTRECOMMENDED: "Ce navigateur n'est pas recommandé.\r\nInternet Explorer Ver. 9, 10, 11 ou Google Chrome sont recommandés.",
		INDEX_SHINKAI:"New carinfo",
        INDEX_SST: "SST",
        DTC_PAGETITLE: "Recherche de DTC",
        DTC_MESSAGE1: "Cliquer sur ALPHANUMERIQUE et entrer le DTC. ",
        DTC_MESSAGE2: "Cliquer sur OK pour afficher les résultats de la recherche.",
        DTC_MESSAGE3: "Afficher tous les DTC.",
        DTC_SHOWALL: "LISTE",
        DTC_SEARCH_RESULT: "R&eacute;sultats de la recherche de codes d&rsquo;anomalie",
        DTC_HEADING_CODE: "DTC",
        DTC_HEADING_ITEM: "Designation",
        DTC_HEADING_LINK: "R&eacute;f&eacute;rence",
        DTC_BACKTO_SEARCH: "Retour &aacute; la page de recherche",
        DTC_NO_ITEM: "Le DTC saisi est introuvable.",
        DTC_CLEAR: "Supprimer",
        DTC_BACK_SPACE: "Touche d&rsquo;effacement arrière",
        DTC_OK: "OK",
        WIRING_TITLE: "Index des schémas de câblage",
        WIRING_DESCRIPTION: "Cliquer sur l'initiale du mot ou de l'expression à rechercher.",
        WIRING_SHOWALL: "Liste",
        WIRING_BASICDIAG: "Proc&eacute;dure de diagnostic de base",
        WIRING_NOTE: "Pr&eacute;cautions &agrave; prendre",
        WIRING_CAUTION: "Les caractères affichés sur un fond gris sont indisponibles.",
        WIRING_SEARCH_RESULT: "R&eacute;sultats de la recherche des sch&eacute;mas de c&acirc;blage",
        LOOKUP_TITLE: "Index",
        LOOKUP_DESCRIPTION: "Cliquer sur l'initiale du mot ou de l'expression à rechercher.",
        LOOKUP_SEARCH_RESULT: "R&eacute;sultats de la recherche",
        LOOKUP_CAUTION: "Les caractères affichés sur un fond gris sont indisponibles.",
        CLICK_IMAGE: "Cliquez sur l'image pour l'agrandir.",
        SEARCH_BOX: "Recherche",
        SEARCH_BTN: "Recherche",
        SEARCH_OPTION_TITLE: "Plage de recherche",
        SEARCH_RESULT_TITLE: "Résultats de la recherche",
    };
    var it = {
        SERVICE_MANUAL: "MANUALE DI ASSISTENZA",
        MAIN_TARGETREQUIRED: "Selezionare un elemento da stampare",
        INDEX_MODEL: "Menu selezione modello",
        INDEX_TOP: "ALTO",
        INDEX_DTC: "Ricerca DTC",
        INDEX_LOOKUP: "Indice",
        INDEX_SEARCH: "Ricerca",
        INDEX_WIRING: "Schema elettrico",
        INDEX_PRINT: "Stampa",
        INDEX_PRINTSSI: "Tipo",
        INDEX_PRINTSI: "Sottosezione",
        INDEX_PRINTSECTION: "Capitolo",
        INDEX_HELP: "Guida",
        INDEX_REPAIR_HARNESS: "R/H",
        INDEX_KUBUN: "INDEX_KUBUN_IT",
        INDEX_BROWSERNOTRECOMMENDED: "Browser non consigliato.\r\nSi consiglia Internet Explorer ver. 9, 10, 11 o Google Chrome.",
		INDEX_SHINKAI:"New carinfo",
        INDEX_SST: "SST",
        DTC_PAGETITLE: "Ricerca DTC ",
        DTC_MESSAGE1: "Fare clic su ALFANUMERICO ed inserire il DTC. ",
        DTC_MESSAGE2: "Fare clic su OK per visualizzare i risultati della ricerca.",
        DTC_MESSAGE3: "Visualizza tutti i DTC.",
        DTC_SHOWALL: "LISTA",
        DTC_SEARCH_RESULT: "Risultati della ricerca dei DTC",
        DTC_HEADING_CODE: "DTC",
        DTC_HEADING_ITEM: "Componente",
        DTC_HEADING_LINK: "Riferimento",
        DTC_BACKTO_SEARCH: "Torna alla pagina di ricerca",
        DTC_NO_ITEM: "Il DTC inserito non è stato trovato.",
        DTC_CLEAR: "Annulla",
        DTC_BACK_SPACE: "Indietro",
        DTC_OK: "OK",
        WIRING_TITLE: "Indice schemi elettrici",
        WIRING_DESCRIPTION: "Fare clic sulla prima lettera della parola o della frase da ricercare.",
        WIRING_SHOWALL: "Lista",
        WIRING_BASICDIAG: "Procedura di diagnosi base",
        WIRING_NOTE: "Precauzioni durante il lavoro",
        WIRING_CAUTION: "I caratteri visualizzati su sfondo grigio non sono disponibili.",
        WIRING_SEARCH_RESULT: "Risultati della ricerca negli schemi elettrici",
        LOOKUP_TITLE: "Indice",
        LOOKUP_DESCRIPTION: "Fare clic sulla prima lettera della parola o della frase da ricercare.",
        LOOKUP_SEARCH_RESULT: "Risultati della ricerca",
        LOOKUP_CAUTION: "I caratteri visualizzati su sfondo grigio non sono disponibili.",
        CLICK_IMAGE: "Fare clic sull'immagine per vedere l'immagine ingrandita.",
        SEARCH_BOX: "Ricerca",
        SEARCH_BTN: "Ricerca",
        SEARCH_OPTION_TITLE: "Intervallo di ricerca",
        SEARCH_RESULT_TITLE: "Risultati della ricerca",
    };
    var zh = {
        SERVICE_MANUAL: "维修手册",
        MAIN_TARGETREQUIRED: "请选择要打印的项目",
        INDEX_MODEL: "车型选择",
        INDEX_TOP: "首页",
        INDEX_DTC: "DTC编码检索",
        INDEX_LOOKUP: "索引",
        INDEX_SEARCH: "检索",
        INDEX_WIRING: "布线图",
        INDEX_PRINT: "打印",
        INDEX_PRINTSSI: "类型",
        INDEX_PRINTSI: "小节",
        INDEX_PRINTSECTION: "章",
        INDEX_HELP: "帮助",
        INDEX_REPAIR_HARNESS: "R/H",
        INDEX_KUBUN: "INDEX_KUBUN_ZH",
        INDEX_BROWSERNOTRECOMMENDED: "不推荐此浏览器。\r\n推荐 Internet Explorer 9、10、11 或 Google Chrome。",
		INDEX_SHINKAI:"New carinfo",
        INDEX_SST: "SST",
        DTC_PAGETITLE: "DTC编码检索",
        DTC_MESSAGE1: "请点击英文数字键输入DTC编码。",
        DTC_MESSAGE2: "按“开始检索”键显示检索结果。",
        DTC_MESSAGE3: "显示所有的DTC编码。",
        DTC_SHOWALL: "一览表",
        DTC_SEARCH_RESULT: "DTC 搜索结果",
        DTC_HEADING_CODE: "DTC",
        DTC_HEADING_ITEM: "项目",
        DTC_HEADING_LINK: "参考",
        DTC_BACKTO_SEARCH: "返回搜索页",
        DTC_NO_ITEM: "无法找到输入的 DTC。",
        DTC_CLEAR: "清除",
        DTC_BACK_SPACE: "退格",
        DTC_OK: "OK",
        WIRING_TITLE: "布线图索引",
        WIRING_DESCRIPTION: "请点击英文字母搜索。",
        WIRING_SHOWALL: "一览表",
        WIRING_BASICDIAG: "基本诊断程序",
        WIRING_NOTE: "工作注意事项",
        WIRING_CAUTION: "※不能选择背景色为灰色的项目。",
        WIRING_SEARCH_RESULT: "布线图搜索结果",
        LOOKUP_TITLE: "索引",
        LOOKUP_DESCRIPTION: "请点击英文字母搜索。",
        LOOKUP_SEARCH_RESULT: "搜索结果",
        LOOKUP_CAUTION: "※不能选择背景色为灰色的项目。",
        CLICK_IMAGE: "点击图像以查看放大图。",
        SEARCH_BOX: "检索",
        SEARCH_BTN: "检索",
        SEARCH_OPTION_TITLE: "检索范围",
        SEARCH_RESULT_TITLE: "搜索结果",
    };
    var ae = {
        SERVICE_MANUAL: "SERVICE MANUAL",
        MAIN_TARGETREQUIRED: "Please select an item to print.",
        INDEX_MODEL: "Model Selection Menu",
        INDEX_TOP: "TOP",
        INDEX_DTC: "DTC Search",
        INDEX_LOOKUP: "Index",
        INDEX_SEARCH: "Search",
        INDEX_WIRING: "Wiring Diagram",
        INDEX_PRINT: "Print",
        INDEX_PRINTSSI: "Type",
        INDEX_PRINTSI: "Subsection",
        INDEX_PRINTSECTION: "Chapter",
        INDEX_HELP: "HELP",
        INDEX_REPAIR_HARNESS: "R/H",
        INDEX_KUBUN: "INDEX_KUBUN_EN",
        INDEX_BROWSERNOTRECOMMENDED: "This browser is not recommended.\r\nInternet Explorer ver.9, 10, 11 or Google Chrome are recommended.",
		INDEX_SHINKAI:"New carinfo",
        INDEX_SST: "SST",
        DTC_PAGETITLE: "DTC Search",
        DTC_MESSAGE1: "Click ALPHANUMERIC and enter the DTC.",
        DTC_MESSAGE2: "Click OK to display the search results.",
        DTC_MESSAGE3: "Display all the DTCs.",
        DTC_SHOWALL: "List",
        DTC_SEARCH_RESULT: "DTC search results",
        DTC_HEADING_CODE: "DTC",
        DTC_HEADING_ITEM: "Item",
        DTC_HEADING_LINK: "Reference",
        DTC_BACKTO_SEARCH: "Back to the search page",
        DTC_NO_ITEM: "The entered DTC cannot be found.",
        DTC_CLEAR: "Clear",
        DTC_BACK_SPACE: "Back Space",
        DTC_OK: "OK",
        WIRING_TITLE: "Wiring Diagram Index",
        WIRING_DESCRIPTION: "Click the initial letter of the word or phrase to be searched.",
        WIRING_SHOWALL: "List",
        WIRING_BASICDIAG: "Basic diagnostic procedure",
        WIRING_NOTE: "Working precautions",
        WIRING_CAUTION: "Characters displayed with a gray background are not available.",
        WIRING_SEARCH_RESULT: "Wiring diagram search results",
        LOOKUP_TITLE: "Index",
        LOOKUP_DESCRIPTION: "Click the initial letter of the word or phrase to be searched.",
        LOOKUP_SEARCH_RESULT: "Search results",
        LOOKUP_CAUTION: "Characters displayed with a gray background are not available.",
        CLICK_IMAGE: "Click the image to see the enlarged image.",
        SEARCH_BOX: "Search",
        SEARCH_BTN: "Search",
        SEARCH_OPTION_TITLE: "Search range",
        SEARCH_RESULT_TITLE: "Search results",
    };

    var load = function(lang) {
        $.extend(msg, {});
        if (lang == "ja") { $.extend(msg, ja); }
        if (lang == "en") { $.extend(msg, en); }
        if (lang == "es") { $.extend(msg, es); }
        if (lang == "de") { $.extend(msg, de); }
        if (lang == "fr") { $.extend(msg, fr); }
        if (lang == "it") { $.extend(msg, it); }
        if (lang == "zh") { $.extend(msg, zh); }
        if (lang == "ae") { $.extend(msg, ae); }
    };

    return {load: load, msg: msg};
})();
try {
    i18n.load(lang);
}
catch (err) { }
